'From Squeak4.3 of 22 December 2011 [latest update: #11860] on 7 September 2012 at 1:41:02 pm'!
BouncingBallMorph subclass: #BouncingBallMorphWithSlider
	instanceVariableNames: 'slider oldBounds'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Morphic-Examples'!

!BouncingBallMorphWithSlider methodsFor: 'event handling' stamp: 'DY 2/8/2011 11:41'!
drawOn: aCanvas
	super drawOn: aCanvas.
	oldBounds ~= self bounds ifTrue: [
		slider bounds:
			(self bounds origin corner: 
				(self bounds origin x + 20) @ self bounds corner y
			)
	].
	oldBounds := self bounds.
	! !

!BouncingBallMorphWithSlider methodsFor: 'event handling' stamp: 'DY 2/8/2011 11:51'!
onSliderMove
	| speed newSpeed |
	speed := ((dx *dx) + (dy * dy)) sqrt.
	speed = 0 ifTrue: [speed := 1].
	newSpeed := slider value * MaxSpeed.
	dx := dx / speed * newSpeed.
	dy := dy / speed * newSpeed.
! !


!BouncingBallMorphWithSlider methodsFor: 'initialization' stamp: 'DY 2/8/2011 11:36'!
openInWorld
	super openInWorld.
	slider := BouncingBallSlider new.
	slider bounds: (self bounds origin corner: 20 @ self bounds corner y).
	self addMorph: slider.
	slider value: ((dx * dx) + (dy * dy)) sqrt / (2 sqrt * MaxSpeed) asFloat.! !
